/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl_native.blocks;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.impl.entity.MCEntityType;
import com.blamejared.crafttweaker.impl.util.MCDirection;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="vanilla/api/block/MCBlockState")
@NativeTypeRegistration(value=BlockState.class, zenCodeName="crafttweaker.api.blocks.MCBlockState")
public class ExpandBlockState {
    @ZenCodeType.Getter(value="block")
    @ZenCodeType.Caster(implicit=true)
    public static Block getBlock(BlockState internal) {
        return internal.func_177230_c();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="lightLevel")
    public static int getLightLevel(BlockState internal) {
        return internal.func_185906_d();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="canProvidePower")
    public static boolean canProvidePower(BlockState internal) {
        return internal.func_185897_m();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isSolid")
    public static boolean isSolid(BlockState internal) {
        return internal.func_200132_m();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="ticksRandomly")
    public static boolean ticksRandomly(BlockState internal) {
        return internal.func_204519_t();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="hasTileEntity")
    public static boolean hasTileEntity(BlockState internal) {
        return internal.hasTileEntity();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isSticky")
    public static boolean isSticky(BlockState internal) {
        return internal.isStickyBlock();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isSlime")
    public static boolean isSlime(BlockState internal) {
        return internal.isSlimeBlock();
    }

    @ZenCodeType.Method
    public static BlockState withProperty(BlockState internal, String name, String value) {
        Property property = internal.func_177230_c().func_176194_O().func_185920_a(name);
        if (property == null) {
            CraftTweakerAPI.logWarning("Invalid property name", new Object[0]);
        } else {
            Optional propValue = property.func_185929_b(value);
            if (propValue.isPresent()) {
                return (BlockState)internal.func_206870_a(property, (Comparable)propValue.get());
            }
            CraftTweakerAPI.logWarning("Invalid property value", new Object[0]);
        }
        return internal;
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="propertyNames")
    public static List<String> getPropertyNames(BlockState internal) {
        ArrayList<String> props = new ArrayList<String>();
        for (Property prop : internal.func_235904_r_()) {
            props.add(prop.func_177701_a());
        }
        return ImmutableList.copyOf(props);
    }

    @ZenCodeType.Method
    public static String getPropertyValue(BlockState internal, String name) {
        Property prop = internal.func_177230_c().func_176194_O().func_185920_a(name);
        if (prop != null) {
            return internal.func_177229_b(prop).toString();
        }
        CraftTweakerAPI.logWarning("Invalid property name", new Object[0]);
        return "";
    }

    @ZenCodeType.Method
    public static List<String> getAllowedValuesForProperty(BlockState internal, String name) {
        Property prop = internal.func_177230_c().func_176194_O().func_185920_a(name);
        if (prop != null) {
            ArrayList<String> values = new ArrayList<String>();
            prop.func_177700_c().forEach(v -> values.add(v.toString()));
            return values;
        }
        CraftTweakerAPI.logWarning("Invalid property name", new Object[0]);
        return ImmutableList.of();
    }

    @ZenCodeType.Method
    public static Map<String, String> getProperties(BlockState internal) {
        HashMap<String, String> props = new HashMap<String, String>();
        for (Property key : internal.func_235904_r_()) {
            props.put(key.func_177701_a(), internal.func_177229_b(key).toString());
        }
        return ImmutableMap.copyOf(props);
    }

    @ZenCodeType.Method
    public static boolean hasProperty(BlockState internal, String name) {
        Property prop = internal.func_177230_c().func_176194_O().func_185920_a(name);
        return prop != null;
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="harvestTool")
    public static @ZenCodeType.Nullable ToolType getHarvestTool(BlockState internal) {
        return internal.getHarvestTool();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="harvestLevel")
    public static int getHarvestLevel(BlockState internal) {
        return internal.getHarvestLevel();
    }

    @ZenCodeType.Method
    public static float getSlipperiness(BlockState internal, World world, BlockPos pos, @ZenCodeType.Optional Entity entity) {
        return internal.getSlipperiness((IWorldReader)world, pos, entity);
    }

    @ZenCodeType.Method
    public static int getLightValue(BlockState internal, World world, BlockPos pos) {
        return internal.getLightValue((IBlockReader)world, pos);
    }

    @ZenCodeType.Method
    public static boolean isLadder(BlockState internal, World world, BlockPos pos, LivingEntity entity) {
        return internal.isLadder((IWorldReader)world, pos, entity);
    }

    @ZenCodeType.Method
    public static boolean canHarvestBlock(BlockState internal, World world, BlockPos pos, PlayerEntity player) {
        return internal.canHarvestBlock((IBlockReader)world, pos, player);
    }

    @ZenCodeType.Method
    public static boolean isBed(BlockState internal, World world, BlockPos pos, @ZenCodeType.Optional LivingEntity sleeper) {
        return internal.isBed((IBlockReader)world, pos, sleeper);
    }

    @ZenCodeType.Method
    public static boolean canCreatureSpawn(BlockState internal, World world, BlockPos pos, EntitySpawnPlacementRegistry.PlacementType type, MCEntityType entityType) {
        return internal.canCreatureSpawn((IWorldReader)world, pos, type, entityType.getInternal());
    }

    @ZenCodeType.Method
    public static void setBedOccupied(BlockState internal, World world, BlockPos pos, LivingEntity sleeper, boolean occupied) {
        internal.setBedOccupied(world, pos, sleeper, occupied);
    }

    @ZenCodeType.Method
    public static void getBedDirection(BlockState internal, World world, BlockPos pos) {
        internal.getBedDirection((IWorldReader)world, pos);
    }

    @ZenCodeType.Method
    public static boolean canBeReplacedByLeaves(BlockState internal, World world, BlockPos pos) {
        return internal.canBeReplacedByLeaves((IWorldReader)world, pos);
    }

    @ZenCodeType.Method
    public static boolean canBeReplacedByLogs(BlockState internal, World world, BlockPos pos) {
        return internal.canBeReplacedByLogs((IWorldReader)world, pos);
    }

    @ZenCodeType.Method
    public static float getExplosionResistance(BlockState internal, World world, BlockPos pos, Explosion explosion) {
        return internal.getExplosionResistance((IBlockReader)world, pos, explosion);
    }

    @ZenCodeType.Method
    public static boolean canConnectRedstone(BlockState internal, World world, BlockPos pos, @ZenCodeType.Optional MCDirection side) {
        return internal.canConnectRedstone((IBlockReader)world, pos, side.getInternal());
    }

    @ZenCodeType.Method
    public static boolean isFertile(BlockState internal, World world, BlockPos pos) {
        return internal.isFertile((IBlockReader)world, pos);
    }

    @ZenCodeType.Method
    public static boolean isConduitFrame(BlockState internal, World world, BlockPos pos, BlockPos conduitPosition) {
        return internal.isConduitFrame((IWorldReader)world, pos, conduitPosition);
    }

    @ZenCodeType.Method
    public static boolean isPortalFrame(BlockState internal, World world, BlockPos pos) {
        return internal.isPortalFrame((IBlockReader)world, pos);
    }

    @ZenCodeType.Method
    public static int getExpDrop(BlockState internal, World world, BlockPos pos, int fortune, int silktouch) {
        return internal.getExpDrop((IWorldReader)world, pos, fortune, silktouch);
    }

    @ZenCodeType.Method
    public static boolean isToolEffective(BlockState internal, ToolType tool) {
        return internal.isToolEffective(tool);
    }

    @ZenCodeType.Method
    public static boolean canStickTo(BlockState internal, BlockState other) {
        return internal.canStickTo(other);
    }

    @ZenCodeType.Method
    public static int getFlammability(BlockState internal, World world, BlockPos pos, MCDirection face) {
        return internal.getFlammability((IBlockReader)world, pos, face.getInternal());
    }

    @ZenCodeType.Method
    public static boolean isFlammable(BlockState internal, World world, BlockPos pos, MCDirection face) {
        return internal.isFlammable((IBlockReader)world, pos, face.getInternal());
    }

    @ZenCodeType.Method
    public static int getFireSpreadSpeed(BlockState internal, World world, BlockPos pos, MCDirection face) {
        return internal.getFireSpreadSpeed((IBlockReader)world, pos, face.getInternal());
    }

    @ZenCodeType.Method
    public static boolean isFireSource(BlockState internal, World world, BlockPos pos, MCDirection side) {
        return internal.isFireSource((IWorldReader)world, pos, side.getInternal());
    }

    @ZenCodeType.Method
    public static boolean canEntityDestroy(BlockState internal, World world, BlockPos pos, Entity entity) {
        return internal.canEntityDestroy((IBlockReader)world, pos, entity);
    }

    @ZenCodeType.Method
    public static boolean isBurning(BlockState internal, World world, BlockPos pos) {
        return internal.isBurning((IBlockReader)world, pos);
    }

    @ZenCodeType.Method
    public static boolean canDropFromExplosion(BlockState internal, World world, BlockPos pos, Explosion explosion) {
        return internal.canDropFromExplosion((IBlockReader)world, pos, explosion);
    }

    @ZenCodeType.Method
    public static boolean isScaffolding(BlockState internal, LivingEntity entity) {
        return internal.isScaffolding(entity);
    }

    @ZenCodeType.Caster
    public static String asString(BlockState internal) {
        return internal.toString();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="commandString")
    public static String getCommandString(BlockState internal) {
        StringBuilder builder = new StringBuilder("<blockstate:");
        builder.append(ExpandBlockState.getBlock(internal).getRegistryName());
        if (!ExpandBlockState.getProperties(internal).isEmpty()) {
            builder.append(":");
            builder.append(ExpandBlockState.getProperties(internal).entrySet().stream().map(kv -> (String)kv.getKey() + "=" + (String)kv.getValue()).collect(Collectors.joining(",")));
        }
        builder.append(">");
        return builder.toString();
    }
}

